import asyncio


########## DEFINITION D'UNE BOUCLE ASYNCIO ##########

loop = asyncio.get_event_loop()


########## GESTION DES ENTREES NUMERIQUES ##########

# DECLARATION D'UNE BROCHE EN ENTREE NUMERIQUE

def Set_DigitalInput_Pin(board, pin):
    loop.run_until_complete(board.set_pin_mode_digital_input(pin))

# LECTURE DE L'ETAT LOGIQUE D'UNE BROCHE DECLAREE EN ENTREE NUMERIQUE

def Digital_Read(board, pin):
    value = loop.run_until_complete(board.digital_read(pin))
    return value[0]


########## GESTION DES SORTIES NUMERIQUES ##########

# DECLARATION D'UNE BROCHE EN SORTIE NUMERIQUE

def Set_DigitalOutput_Pin(board, pin):
    loop.run_until_complete(board.set_pin_mode_digital_output(pin))

# MODIFICATION DE L'ETAT LOGIQUE D'UNE SORTIE NUMERIQUE

def Digital_Write(board, pin, val):
    loop.run_until_complete(board.digital_write(pin, val))


########## GESTION DES ENTREES ANALOGIQUES ##########

# DECLARATION D'UNE BROCHE EN ENTREE ANALOGIQUE

def Set_AnalogInput_Pin(board,pin):
    loop.run_until_complete(board.set_pin_mode_analog_input(pin))

# LECTURE DE LA VALEUR DE L'ENTREE ANALOGIQUE

def Analog_Read(board, pin):
    value = loop.run_until_complete(board.analog_read(pin))
    return value[0]


########## GESTION DES SORTIES ANALOGIQUES ##########

# DECLARATION D'UNE BROCHE EN SORTIE ANALOGIQUE

def Set_AnalogOutput_Pin(board,pin):
    loop.run_until_complete(board.set_pin_mode_pwm(pin))

# MODIFICATION DE LA VALEUR D'UNE SORTIE ANALOGIQUE

def Analog_Write(board, pin, val):
    loop.run_until_complete(board.analog_write(pin, val))


########## GESTION DU SON ##########

# DECLARATION D'UNE BROCHE EN MODE TONE

def Set_Tone_Pin(board,pin):
    loop.run_until_complete(board.set_pin_mode_tone(pin))
    
# EMISSION SONORE

def Tone(board,pin,freq,duration):
    if duration>0:
        loop.run_until_complete(board.play_tone(pin, freq, duration))
    else:
        loop.run_until_complete(board.play_tone_continuously(pin, freq))
                                
# ARRET DE L'EMISSION SONORE

def No_Tone(board,pin):
    loop.run_until_complete(board.play_tone_off(pin))


########## DECONNEXION DE L'ARDUINO ##########

def Arduino_Exit(board):
    loop.run_until_complete(board.shutdown())



