# Importations des librairies et définition des fonctions

from PymataExpressDef import *
from ConnectToArduino import *
import time


# Déclaration des constantes et variables

PinSensor=0
PinButton= 12
PinLed = 8
PinTone = 3

ValSensor = 0
tension = 0.0
Temp = 0.0
OldTemp = 0.0
TempAlarme = 22.0

ValButton = 0
OldValButton = 0
State = 0
OldState = 0


# Connexion à l'Arduino

PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)


# Connexion à l'Arduino réussie - Déclaration des entrées et sorties

Set_AnalogInput_Pin(board, PinSensor)
Set_DigitalOutput_Pin(board, PinLed)
Set_DigitalInput_Pin(board, PinButton)
Set_Tone_Pin(board,PinTone)

print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter.\n")
print("Appuyez sur le bouton poussoir pour commencer les mesures.\n");


# Boucle principale du programme

while True:
    try:
        ValButton = Digital_Read(board, PinButton)
        time.sleep(0.01)
        if ValButton == 1 and OldValButton == 0:
            State=1-State
  
        OldValButton = ValButton;

        if State==1:  
            if OldState == 0:
               print("\nMesure de la température en cours.\n")
               print("Température en degré Celsius:")
               OldState=1
        
            sensorVal = Analog_Read(board, PinSensor)
            tension = (sensorVal/1023)*5

            # Capteur TMP 36
            Temp = (tension - 0.5) * 100;

            # Capteur LM 35
            # Temp = tension * 100;

            if OldTemp != Temp:
                print(round(Temp,1))
                OldTemp = Temp

            if Temp > TempAlarme:  
                Digital_Write(board, PinLed, 1)
                Tone(board, PinTone,440, 0)
                time.sleep(0.1)
                Digital_Write(board, PinLed, 0)
                No_Tone(board, PinTone)
                time.sleep(0.1)  
            else:  
                Digital_Write(board, PinLed, 0)
                No_Tone(board, PinTone)

            time.sleep(0.1)

        else:
            if OldState == 1:
                print("Fin des mesures.\n")
                OldState = 0 

    except KeyboardInterrupt:
        Digital_Write(board, PinLed, 0)
        No_Tone(board, PinTone)
        Arduino_Exit(board)
        sys.exit(0)
