# Importations des librairies et définition des fonctions

from PymataExpressDef import *
from ConnectToArduino import *
import time


# Déclaration des constantes et variables

PinTMP = 0
PinCTN = 5
PinButton = 12

ValTMP = 0
ValCTN = 0
TempTMP = 0.0
OldTempTMP = 0.0
Rctn = 0.0
Vctn = 0.0

ValButton = 0
OldValButton = 0
State = 0
OldState = 0


# Connexion à l'Arduino

PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)


# Connexion à l'Arduino réussie - Déclaration des entrées et sorties

Set_AnalogInput_Pin(board, PinTMP)
Set_AnalogInput_Pin(board, PinCTN)
Set_DigitalInput_Pin(board, PinButton)

print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter.\n")
print("Appuyez sur le bouton poussoir pour commencer les mesures.\n");


# Boucle principale du programme

while True:
    try:
        ValButton = Digital_Read(board, PinButton)
        time.sleep(0.01)
        if ValButton == 1 and OldValButton == 0:
            State=1-State
  
        OldValButton = ValButton;

        if State==1:  
            if OldState == 0:
               print("\nMesure de la température et de la résistance de la CTN en cours.\n")
               print("Température en degré Celsius ; Résistance CTN en Ohms:")
               OldState=1
        
            ValTMP = Analog_Read(board, PinTMP)

            # Capteur TMP 36
            TempTMP = ((ValTMP/1023)*5 - 0.5) * 100

            # Capteur LM 35
            # TempTMP = (ValTMP/1023)*5 * 100

            ValCTN = Analog_Read(board, PinCTN)
            Vctn = (ValCTN/1023.0)*5.0
            Rctn = 10000*Vctn/(5-Vctn)

            if OldTempTMP != TempTMP:
                print(round(TempTMP,1), " ; ", round(Rctn,1))
                OldTempTMP = TempTMP

            time.sleep(0.1)

        else:
            if OldState == 1:
                print("\nFin des mesures.\n")
                OldState = 0 

    except KeyboardInterrupt:
        Arduino_Exit(board)
        sys.exit(0)
