# Importations des librairies et définition des fonctions

from PymataExpressDef import *
from ConnectToArduino import *
import time

# Déclaration des constantes et variables

PinSensor = 0
sensorVal = 0
tension = 0
temperature = 0


# Connexion à l'Arduino

PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)


# Connexion à l'Arduino réussie - Déclaration des entrées et sorties


Set_AnalogInput_Pin(board, PinSensor)

print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter.")


# Boucle principale du programme

while True:
    try:
        sensorVal = Analog_Read(board, PinSensor)
        tension = (sensorVal/1023)*5

        # Capteur TMP 36
        temperature = (tension - 0.5) * 100;

        # Capteur LM 35
        # temperature = tension * 100;

        print(sensorVal, " ; ", round(tension,2), " ; ", round(temperature,1))
        time.sleep(0.1)

    except KeyboardInterrupt:
        Arduino_Exit(board)
        sys.exit(0)
