// Déclaration des constantes et variables

const int PinTMP = 0;
const int PinCTN = 5;
const int PinButton = 12;


int ValTMP = 0;
int ValCTN = 0;
float TempTMP = 0.0;
float OldTempTMP = 0.0;
float Rctn = 0.0;
float Vctn = 0.0;


int ValButton = 0;
int OldValButton = 0;
int State = 0;
int OldState = 0;


// Initialisation des entrées et sorties

void setup() {
  Serial.begin(9600);
  pinMode(PinButton,INPUT);
  Serial.println("Appuyez sur le bouton poussoir pour commencer les mesures.");
}


// Fonction principale en boucle

void loop() {
  ValButton = digitalRead(PinButton);
  delay(10);

  if ((ValButton == HIGH)&&(OldValButton == LOW)) 
  {
  State=1-State;
  }
  OldValButton = ValButton;

  if (State==1) 
  {
    if (OldState == 0)
    {
    Serial.println("Mesure de la temperature et de la resistance de la CTN en cours.");
    Serial.println("");
    Serial.println ("Temperature en degre Celsius ; Resistance CTN en Ohms:");
    OldState=1;
    }
    ValTMP = analogRead(PinTMP);
    // Capteur TMP 36
    TempTMP = ((ValTMP/1023.0)*5.0 - 0.5) * 100;
    // Capteur LM 35
    //TempTMP = (ValTMP/1023.0)*5.0 * 100;

    ValCTN = analogRead(PinCTN);
    Vctn = (ValCTN/1023.0)*5.0;
    Rctn = 10000*Vctn/(5-Vctn);
  
    if (OldTempTMP != TempTMP)
    {
      Serial.print(TempTMP,1);
      Serial.print(" ; ");
      Serial.println(Rctn,1);
      OldTempTMP = TempTMP;
    }

  delay(100);
  }
  else
  {
    if (OldState == 1){
    Serial.println("Fin des mesures.");
    OldState = 0;} 
  }   
}
