# Importations des librairies et définition des fonctions

from PymataExpressDef import *
from ConnectToArduino import *
import time
import math

def InputVal(msg, valmin, valmax, unit):
    InputValid = False
    while InputValid==False:
        val = input(msg+"(valeur entre {0} et {1} {2}) :" .format(valmin, valmax, unit))
        try:
            val = int(val)
            assert val >= valmin and val <= valmax   

        except AssertionError:
            print("La valeur saisie n'est pas entre {0} et {1} {2} !".format(valmin, valmax, unit))
            
        except:
            print("vous n'avez pas saisi une valeur entre {0} et {1} {2} !".format(valmin, valmax, unit))

        else:
            InputValid = True

    return val
        

# Déclaration des constantes et variables

PinCTN = 5
PinButton = 12

ValCTN = 0
Temp = 0.0
OldTemp = 0.0
Rt = 0.0
Vctn = 0.0
TempRef = 0
Ro = 0
B = 0

ValButton = 0
OldValButton = 0
State = 0
OldState = 0


# Connexion à l'Arduino

PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)


# Connexion à l'Arduino réussie - Déclaration des entrées et sorties

Set_AnalogInput_Pin(board, PinCTN)
Set_DigitalInput_Pin(board, PinButton)

print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter.\n")

TempRef = InputVal("Veuillez saisir la température de référence ",1,100,"°C")
Ro = InputVal("Veuillez saisir la valeur de la résistance nominale ",1,200000,"Ohms")
B = InputVal("Veuillez saisir la constante B ",1,10000,"K")

print("\nAppuyez sur le bouton poussoir pour commencer les mesures.\n");


# Boucle principale du programme

while True:
    try:
        ValButton = Digital_Read(board, PinButton)
        time.sleep(0.01)
        if ValButton == 1 and OldValButton == 0:
            State=1-State
  
        OldValButton = ValButton;

        if State==1:  
            if OldState == 0:
               print("\nMesure de la température en cours.\n")
               print("Résistance CTN en Ohms ; Température en degré Celsius:")
               OldState=1

            ValCTN = Analog_Read(board, PinCTN)
            Vctn = (ValCTN/1023.0)*5.0
            Rt = 10000*Vctn/(5-Vctn)
            Temp = 1.0/(math.log(Rt/Ro)/B+1/(TempRef+273.15))-273.15

            if OldTemp != Temp:
                print(round(Rt,1), " ; ", round(Temp,1))
                OldTemp = Temp

            time.sleep(0.1)

        else:
            if OldState == 1:
                print("\nFin des mesures.\n")
                OldState = 0 

    except KeyboardInterrupt:
        Arduino_Exit(board)
        sys.exit(0)
