# Importations des librairies et définition de fonctions

from PyFirmataDef import *
from ConnectToArduino import *
import time


# Déclaration des constantes et variables

PinSensor = 0
PinButton = 12

ValSensor = 0
tension = 0
Pression = 0
PRef = 0
Dz=0
OldDz = 0

ValButton = 0
OldValButton = 0
State = 0
OldState = 0
BtnAppui = False


# Connexion à l'Arduino

print("\nConnexion à l'Arduino en cours...")
             
PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)

InputPinSensor = AnalogInput(board, PinSensor)
InputPinButton = DigitalInput(board, PinButton)
  
ArduinoIterateur = Iterateur(board)
time.sleep(0.5)

print("\nConnexion à l'Arduino établie - Appuyez sur Ctrl-C pour quitter.\n")

print("Placez le tuyau à la position de référence et appuyez sur le bouton poussoir.\n")

while BtnAppui==False:
    ValButton = InputPinButton.read()
    if ValButton == 1 and OldValButton == 0:
       BtnAppui=True
    time.sleep(0.2)

OldValButton = ValButton
ValSensor = InputPinSensor.read()
tension = ValSensor*5.0
PRef = (tension / 0.02) + 10

print("\nDéplacez le tuyau et appuyez sur le bouton poussoir pour commencer les mesures.\n")
    

# Boucle principale du programme

while True:
    try:
        ValButton = InputPinButton.read()
        time.sleep(0.01)
        if ValButton == 1 and OldValButton == 0:
            State=1-State
  
        OldValButton = ValButton;

        if State==1:  
            if OldState == 0:
               print("\nMesure de la pression en cours.\n")
               print("Pression (en kPa) ; Profondeur (cm):")
               OldState=1
        
            ValSensor = InputPinSensor.read()
            tension = ValSensor*5.0
            Pression = (tension / 0.02) + 10
            Dz = 100*(Pression-PRef)/9.81

            if (abs(OldDz - Dz)>2):
                print(round(Pression,1), " ; ",round(Dz,0))
                OldDz = Dz

            time.sleep(0.5)

        else:
            if OldState == 1:
                print("\nFin des mesures.\n")
                OldState = 0 
                       
    except KeyboardInterrupt:
        board.exit()
        sys.exit(0)

