# Importations des librairies et définition de fonctions

from PyFirmataDef import *
from ConnectToArduino import *
import time


# Déclaration des constantes et variables

PinSensor = 0
PinButton = 12
PinLed = 9
PMax = 200
PMin = 55

ValSensor = 0
tension = 0
Pression = 0
OldPression = 0

ValButton = 0
OldValButton = 0
State = 0
OldState = 0


# Connexion à l'Arduino

print("\nConnexion à l'Arduino en cours...")
             
PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)

InputPinSensor = AnalogInput(board, PinSensor)
InputPinButton = DigitalInput(board, PinButton)
  
ArduinoIterateur = Iterateur(board)
time.sleep(0.5)

print("\nConnexion à l'Arduino établie - Appuyez sur Ctrl-C pour quitter\n")
print("\nAppuyez sur le bouton poussoir pour commencer les mesures.\n");
    

# Boucle principale du programme

while True:
    try:
        ValButton = InputPinButton.read()
        time.sleep(0.01)
        if ValButton == 1 and OldValButton == 0:
            State=1-State
  
        OldValButton = ValButton;

        if State==1:  
            if OldState == 0:
               print("\nMesure de la pression en cours.\n")
               print("Tension Entree A0 (en V) ; Pression (en kPa):")
               OldState=1
        
            ValSensor = InputPinSensor.read()
            tension = ValSensor*5.0
            Pression = (tension / 0.02) + 10

            if OldPression != Pression:
                print(round(tension,2), " ; ", round(Pression,1))
                OldPression = Pression

            if Pression>PMax or Pression<PMin:
                DigitalWrite(board,PinLed,1)
            else:
                DigitalWrite(board,PinLed,0)

            time.sleep(0.5)

        else:
            if OldState == 1:
                print("\nFin des mesures.\n")
                DigitalWrite(board,PinLed,0)
                OldState = 0 
                       
    except KeyboardInterrupt:
        DigitalWrite(board,PinLed,0)
        board.exit()
        sys.exit(0)

