# Programme associé avec "Parseint.ino"

# Importations des librairies et définition des fonctions

from ConnectToArduino import *

import threading

class MyThread(threading.Thread):
    def __init__(self, target):
        threading.Thread.__init__(self)
        self.target = target
        self.StopThread = False
    def run(self):
        while not self.StopThread:
            self.target()
    def stop(self):
        self.StopThread = True

def ImportDonneeSerial():
    global DonneeRecue
    donnees=str(SerialPort.readline())
    if donnees!="b''":
        donnees=donnees[2:len(donnees)-5]
        if donnees!="":
            print(donnees)
            DonneeRecue=DonneeRecue+1

# Déclaration des constantes et variables

donnees = ''
DonneeRecue = 0

# Connexion à l'Arduino

PortComArduino = SelectPortCOM()
SerialPort = OpenPortCom(PortComArduino)

print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter")

# Boucle principale du programme

SerialThread = MyThread(ImportDonneeSerial)
SerialThread.start()

while True:
    try:
        if DonneeRecue==1:

            SaisieOk=False
            while SaisieOk==False:
                saisie = input("")
                try:
                    saisie=int(saisie)
                    assert saisie >= 1 and saisie <= 255
                    SaisieOk = True
                except AssertionError:
                    print("Le nombre indiqué n'est pas entre 1 et 255 !")
                    SaisieOk = False           
                except:
                    print("Vous n'avez pas saisi un nombre entre 1 et 255 !")

            SerialPort.write(str(saisie).encode('utf-8'))
            DonneeRecue=0
            
    except KeyboardInterrupt:
        SerialThread.stop()
        SerialPort.close()
        sys.exit(0)
