# Fonction pour ouvrir un fichier d'inventaire et stocker les données dans
# un dictionnaire si le fichier existe:
def OuvreInventaire():
    global Inventaire
    InventPath=input("Indiquez le nom de l'inventaire:")
    Inventaire = {}
    try:
        with open(InventPath, 'r') as fichier:
            for line in fichier:
                listline=line.split(";")
                Inventaire[listline[0]]=listline[1].strip()

    except Exception as message:
        print(message)

# Fonction pour ajouter une ligne à l'inventaire ouvert ou initialement vide:
def AjoutMatos():
    global Inventaire
    Matos=input("saisissez le type de matériel à ajouter à l'inventaire:")
    Quant=input("saisissez la quantité de ce matériel:")
    Inventaire[Matos]=Quant

#Fonction pour effacer une ligne de l'inventaire en cours:
def EffaceMatos():
    global Inventaire
    element=input("saisissez l'élément à supprimer dans l'inventaire:")        
    try:
        del Inventaire[element]
    except:
        print("L'élément que vous voulez supprimer n'existe pas!")
    
#Fonction pour afficher l'inventaire en cours:
def ReadInventaire():
    global Inventaire
    for cle, valeur in Inventaire.items():
        print("{} : {}".format(cle, valeur))    

#Fonction pour sauvegarder l'inventaire en cours:
def SaveInventaire():
    global Inventaire
    InventPath=input("Indiquez le nom de sauvegarde de l'inventaire:")
    with open(InventPath, 'w') as fichier:
        for cle, valeur in Inventaire.items():
            fichier.write("{};{}".format(cle, valeur))
            fichier.write("\n")

# initialisation des variables:
Inventaire = {}
Fin =False

print("////////////// INVENTAIRE MATERIEL //////////////")
print("appuyer sur O pour ouvrir un inventaire:")
print("appuyer sur A pour ajouter un matériel à l'inventaire:")
print("appuyer sur S pour supprimer un matériel de l'inventaire:")
print("appuyer sur V pour afficher la liste de matériel:")
print("appuyer sur E pour enregistrer l'inventaire:")
print("appuyer sur Q pour quitter:")
print("////////////////////////////////////////////////")
print(" ")

# programme principal:
while Fin == False:

    # attente d'un choix:
    choix=input()

    # Action en fonction de l'entrée clavier:
    if choix.upper() == "O": OuvreInventaire()
    if choix.upper() == "A": AjoutMatos()            
    if choix.upper() == "V": ReadInventaire()            
    if choix.upper() == "S": EffaceMatos()
    if choix.upper() == "E": SaveInventaire()        
    if choix.upper() == "Q":
        print("Fin du programme")
        Fin = True
