import pickle

# Fonction pour ouvrir le fichier d'inventaire et stocker les données dans
# un dictionnaire si le fichier existe:
def OuvreInventaire():
    global Inventaire
    Inventaire = {}
    try:
        with open('fileInvent', 'rb') as fichierInvent:
            Invent_depickler = pickle.Unpickler(fichierInvent)
            Inventaire = Invent_depickler.load()
    except Exception as message:
        print(message)

#Fonction pour sauvegarder l'inventaire en cours:
def SaveInventaire():
    global Inventaire
    with open('fileInvent', 'wb') as fichierInvent:
        Invent_pickler = pickle.Pickler(fichierInvent)
        Invent_pickler.dump(Inventaire)

# Fonction pour ajouter une ligne à l'inventaire ouvert ou initialement vide
# et enregistrer les modifications:
def AjoutMatos():
    global Inventaire
    Matos=input("saisissez le type de matériel à ajouter à l'inventaire:")
    Quant=input("saisissez la quantité de ce matériel:")
    Inventaire[Matos]=Quant
    SaveInventaire()

#Fonction pour effacer une ligne de l'inventaire en cours
# et enregistrer les modifications:
def EffaceMatos():
    global Inventaire
    element=input("saisissez l'élément à supprimer dans l'inventaire:")        
    try:
        del Inventaire[element]
        SaveInventaire()
    except:
        print("L'élément que vous voulez supprimer n'existe pas!")
    
#Fonction pour afficher l'inventaire en cours:
def ReadInventaire():
    global Inventaire
    OuvreInventaire()
    for cle, valeur in Inventaire.items():
        print("{} : {}".format(cle, valeur))    


# initialisation des variables:
Inventaire = {}
Fin =False

print("////////////////// INVENTAIRE MATERIEL //////////////////")
print("appuyer sur A pour ajouter un matériel à l'inventaire.")
print("appuyer sur S pour supprimer un matériel de l'inventaire.")
print("appuyer sur V pour afficher la liste de matériel.")
print("appuyer sur Q pour quitter.")
print("/////////////////////////////////////////////////////////")
print(" ")

# programme principal:
while Fin == False:

    # attente d'un choix:
    choix=input()

    # Action en fonction de l'entrée clavier:
    if choix.upper() == "A": AjoutMatos()            
    if choix.upper() == "V": ReadInventaire()            
    if choix.upper() == "S": EffaceMatos()      
    if choix.upper() == "Q":
        print("Fin du programme")
        Fin = True
