import matplotlib.pyplot as plt
import numpy as np

plt.style.use('seaborn-whitegrid')

x = np.linspace(0, 2*np.pi, 50)
y = np.sin(x)
y2 = np.cos(x)

fig = plt.figure(figsize = (15, 5))
ax1 = plt.subplot(121)
ax2 = plt.subplot(122)

ax1.set_title("Fonction sinus")
ax2.set_title("Fonction cosinus")

ax1.set_xlim(0, 2*np.pi)
ax1.set_ylim(-1.5, 1.5)
ax2.set_xlim(0, 2*np.pi)
ax2.set_ylim(-1.5, 1.5)

ax1.set_xlabel("x(rad)")
ax2.set_xlabel("x(rad)")
ax1.set_ylabel("sin(x)")
ax2.set_ylabel("cos(x)")

ax1.plot(x, y,"r",label="sin(x)")
ax2.plot(x, y2,"b",label="cos(x)")

ax1.legend()
ax2.legend()

fig.show()
