import matplotlib.pyplot as plt
import numpy as np

plt.style.use('seaborn-whitegrid')

x = np.linspace(0, 2*np.pi, 50)
y = np.sin(x)
y2 = np.cos(x)
y3 = np.sin(x+np.pi/2)
y4 = np.cos(x+np.pi/2)

fig = plt.figure(figsize = (15, 8))
ax1 = plt.subplot(221)
ax2 = plt.subplot(222)
ax3 = plt.subplot(223)
ax4 = plt.subplot(224)

ax1.set_title("Fonctions sinus"), ax2.set_title("Fonctions cosinus")

ax1.set_xlim(0, 2*np.pi),ax1.set_ylim(-1.5, 1.5)
ax2.set_xlim(0, 2*np.pi),ax2.set_ylim(-1.5, 1.5)
ax3.set_xlim(0, 2*np.pi),ax3.set_ylim(-1.5, 1.5)
ax4.set_xlim(0, 2*np.pi),ax4.set_ylim(-1.5, 1.5)

ax1.set_xlabel("x(rad)"),ax2.set_xlabel("x(rad)")
ax3.set_xlabel("x(rad)"),ax4.set_xlabel("x(rad)")
ax1.set_ylabel("sin(x)"),ax3.set_ylabel("sin(x)")
ax2.set_ylabel("cos(x)"),ax4.set_ylabel("cos(x)")

ax1.plot(x, y,"r",label="sin(x)"),ax2.plot(x, y2,"b",label="cos(x)")
ax3.plot(x, y3,"g",label="sin(x + pi/2)"),ax4.plot(x, y4,"y",label="cos(x+ pi/2)")

ax1.legend(),ax2.legend(),ax3.legend(),ax4.legend()

fig.show()
