import matplotlib.pyplot as plt
import numpy as np

x = np.linspace(0, 2*np.pi, 50)
y = np.sin(x)
y2 = np.sin(x+np.pi/4)
y3 = np.sin(x+np.pi/2)
y4 = np.sin(x+np.pi)

plt.xlim(0, 2*np.pi)
plt.ylim(-1.1, 1.1)

plt.title("Fonctions sinus")

plt.xlabel("x(rad)")
plt.ylabel("sin(x)")

plt.plot(x, y, "b-.",label="sin(x)")
plt.plot(x, y2,"r:o", label="sin(x + pi/4)")
plt.plot(x, y3,"g--x", label="sin(x + pi/2)")
plt.plot(x, y4,"y+", label="sin(x + pi)")

plt.legend()
plt.show()
