// Inclusion des librairies

#include <math.h>

// Déclaration des constantes et variables

const int PinCTN = 5;
const int PinButton = 12;

int ValCTN = 0;
float Temp = 0.0;
float OldTemp = 0.0;
float Rt = 0.0;
float Vctn = 0.0;
int TempRef = 0;
long Ro = 0;
int B = 0;

int ValButton = 0;
int OldValButton = 0;
int State = 0;
int OldState = 0;


// Initialisation des entrées et sorties

void setup() {
  Serial.begin(9600);
  pinMode(PinButton,INPUT);
  Serial.print("Veuillez saisir la temperature de reference ");
  Serial.println("(valeur entre 1 et 100 degre Celsius).");
   while(TempRef<1 || TempRef>100)  
  {     
    TempRef=Serial.parseInt();
  }
  Serial.print("Temperature de reference (degre Celsius) : "); 
  Serial.println(TempRef);
  Serial.println("");

  Serial.print("Veuillez saisir la valeur de la resistance nominale ");
  Serial.println("(valeur entre 1 et 200000 ohms).");
   while(Ro<1 || Ro>200000)  
  {     
    Ro=Serial.parseInt();
  }
  Serial.print("Resistance nominale (ohms) : "); Serial.println(Ro);
  Serial.println("");
  
  Serial.print("Veuillez saisir la constante B ");
  Serial.println("(valeur entre 1 et 10000 K).");
   while(B<1 || B>10000)  
  {     
    B=Serial.parseInt();
  }
  Serial.print("Constante B (K) : "); Serial.println(B);
  Serial.println("");
  
  Serial.println("Appuyez sur le bouton poussoir pour commencer les mesures.");
}


// Fonction principale en boucle

void loop() {
  ValButton = digitalRead(PinButton);
  delay(10);

  if ((ValButton == HIGH)&&(OldValButton == LOW)) 
  {
  State=1-State;
  }
  OldValButton = ValButton;

  if (State==1) 
  {
    if (OldState == 0)
    {
    Serial.println("Mesure de la temperature en cours.");
    Serial.println("");
    Serial.println ("Resistance CTN en Ohms; Temperature en degre Celsius:");
    OldState=1;
    }

    ValCTN = analogRead(PinCTN);
    Vctn = (ValCTN/1023.0)*5.0;
    Rt = 10000*Vctn/(5-Vctn);
    Temp = 1.0/(log(Rt/Ro)/B+1/(TempRef+273.15))-273.15;
 
    if (OldTemp != Temp)
    {
      Serial.print(Rt,1);
      Serial.print(" ; ");
      Serial.println(Temp,1);
      OldTemp = Temp;
    }

  delay(100);
  }
  else
  {
    if (OldState == 1){
    Serial.println("Fin des mesures.");
    OldState = 0;} 
  }   
}
